/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.MXBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanSupport;
import com.sun.jmx.mbeanserver.PerInterface;
import com.sun.jmx.mbeanserver.StandardMBeanIntrospector;
import com.sun.jmx.mbeanserver.StandardMBeanSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.Descriptor;
import javax.management.DescriptorKey;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector {
    private static final String attributeDescription = "Attribute exposed for management";
    private static final String operationDescription = "Operation exposed for management";
    private static final String constructorDescription = "Public constructor of the MBean";
    private static final String mbeanInfoDescription = "Information on the management interface of the MBean";

    private Introspector() {
    }

    public static final boolean isDynamic(Class clazz) {
        return DynamicMBean.class.isAssignableFrom(clazz);
    }

    public static void testCreation(Class clazz) throws NotCompliantMBeanException {
        int n = clazz.getModifiers();
        if (Modifier.isAbstract(n) || Modifier.isInterface(n)) {
            throw new NotCompliantMBeanException("MBean class must be concrete");
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        if (constructorArray.length == 0) {
            throw new NotCompliantMBeanException("MBean class must have public constructor");
        }
    }

    public static void checkCompliance(Class clazz) throws NotCompliantMBeanException {
        if (DynamicMBean.class.isAssignableFrom(clazz)) {
            return;
        }
        try {
            Introspector.getStandardMBeanInterface(clazz);
            return;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            NotCompliantMBeanException notCompliantMBeanException2 = notCompliantMBeanException;
            try {
                Introspector.getMXBeanInterface(clazz);
                return;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException3) {
                NotCompliantMBeanException notCompliantMBeanException4 = notCompliantMBeanException3;
                String string = "MBean class " + clazz.getName() + " does not implement " + "DynamicMBean, neither follows the Standard MBean conventions (" + notCompliantMBeanException2.toString() + ") nor the MXBean conventions (" + notCompliantMBeanException4.toString() + ")";
                throw new NotCompliantMBeanException(string);
            }
        }
    }

    public static DynamicMBean makeDynamicMBean(Object object) throws NotCompliantMBeanException {
        if (object instanceof DynamicMBean) {
            return (DynamicMBean)object;
        }
        Class<?> clazz = object.getClass();
        Class clazz2 = null;
        try {
            clazz2 = Introspector.getStandardMBeanInterface(clazz);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            // empty catch block
        }
        if (clazz2 != null) {
            return new StandardMBeanSupport(object, clazz2);
        }
        try {
            clazz2 = Introspector.getMXBeanInterface(clazz);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            // empty catch block
        }
        if (clazz2 != null) {
            return new MXBeanSupport(object, clazz2);
        }
        Introspector.checkCompliance(clazz);
        throw new NotCompliantMBeanException("Not compliant");
    }

    public static MBeanInfo testCompliance(Class clazz) throws NotCompliantMBeanException {
        if (Introspector.isDynamic(clazz)) {
            return null;
        }
        return Introspector.testCompliance(clazz, null);
    }

    public static void testComplianceMXBeanInterface(Class clazz) throws NotCompliantMBeanException {
        MXBeanIntrospector.getInstance().getAnalyzer(clazz);
    }

    public static synchronized MBeanInfo testCompliance(Class<?> clazz, Class<?> clazz2) throws NotCompliantMBeanException {
        if (clazz2 == null) {
            clazz2 = Introspector.getStandardMBeanInterface(clazz);
        }
        StandardMBeanIntrospector standardMBeanIntrospector = StandardMBeanIntrospector.getInstance();
        PerInterface perInterface = standardMBeanIntrospector.getPerInterface(clazz2);
        return standardMBeanIntrospector.getClassMBeanInfo(clazz, perInterface);
    }

    public static Class getMBeanInterface(Class clazz) {
        if (Introspector.isDynamic(clazz)) {
            return null;
        }
        try {
            return Introspector.getStandardMBeanInterface(clazz);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            return null;
        }
    }

    public static Class getStandardMBeanInterface(Class clazz) throws NotCompliantMBeanException {
        Class clazz2 = null;
        for (Class clazz3 = clazz; clazz3 != null && (clazz2 = Introspector.findMBeanInterface(clazz3, clazz3.getName())) == null; clazz3 = clazz3.getSuperclass()) {
        }
        if (clazz2 != null) {
            return clazz2;
        }
        String string = "Class " + clazz.getName() + " is not a JMX compliant Standard MBean";
        throw new NotCompliantMBeanException(string);
    }

    public static Class getMXBeanInterface(Class clazz) throws NotCompliantMBeanException {
        try {
            return MXBeanSupport.findMXBeanInterface(clazz);
        }
        catch (Exception exception) {
            throw Introspector.throwException(clazz, exception);
        }
    }

    private static Class findMBeanInterface(Class clazz, String string) {
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class clazz3 = Introspector.implementsMBean(classArray[i], string);
                if (clazz3 == null) continue;
                return clazz3;
            }
        }
        return null;
    }

    public static Descriptor descriptorForElement(AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        Annotation[] annotationArray = annotatedElement.getAnnotations();
        return Introspector.descriptorForAnnotations(annotationArray);
    }

    public static Descriptor descriptorForAnnotations(Annotation[] annotationArray) {
        if (annotationArray.length == 0) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Annotation annotation : annotationArray) {
            Method[] methodArray;
            Class<? extends Annotation> clazz = annotation.annotationType();
            for (Method method : methodArray = clazz.getMethods()) {
                Object object;
                DescriptorKey descriptorKey = method.getAnnotation(DescriptorKey.class);
                if (descriptorKey == null) continue;
                String string = descriptorKey.value();
                try {
                    object = method.invoke(annotation, new Object[0]);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new UndeclaredThrowableException(exception);
                }
                object = Introspector.annotationToField(object);
                Object object2 = hashMap.put(string, object);
                if (object2 == null || Introspector.equals(object2, object)) continue;
                String string2 = "Inconsistent values for descriptor field " + string + " from annotations: " + object + " :: " + object2;
                throw new IllegalArgumentException(string2);
            }
        }
        if (hashMap.isEmpty()) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        return new ImmutableDescriptor(hashMap);
    }

    static NotCompliantMBeanException throwException(Class<?> clazz, Throwable throwable) throws NotCompliantMBeanException, SecurityException {
        if (throwable instanceof SecurityException) {
            throw (SecurityException)throwable;
        }
        if (throwable instanceof NotCompliantMBeanException) {
            throw (NotCompliantMBeanException)throwable;
        }
        String string = clazz == null ? "null class" : clazz.getName();
        String string2 = throwable == null ? "Not compliant" : throwable.getMessage();
        NotCompliantMBeanException notCompliantMBeanException = new NotCompliantMBeanException(string + ": " + string2);
        notCompliantMBeanException.initCause(throwable);
        throw notCompliantMBeanException;
    }

    private static Object annotationToField(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number || object instanceof String || object instanceof Character || object instanceof Boolean || object instanceof String[]) {
            return object;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                return object;
            }
            Object[] objectArray = (Object[])object;
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = (String)Introspector.annotationToField(objectArray[i]);
            }
            return stringArray;
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        throw new IllegalArgumentException("Illegal type for annotation element: " + object.getClass().getName());
    }

    private static boolean equals(Object object, Object object2) {
        return Arrays.deepEquals(new Object[]{object}, new Object[]{object2});
    }

    private static Class implementsMBean(Class clazz, String string) {
        String string2 = string + "MBean";
        if (clazz.getName().equals(string2)) {
            return clazz;
        }
        Class clazz2 = clazz;
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].getName().equals(string2)) continue;
            return classArray[i];
        }
        return null;
    }
}

